//
//  TrustedApplication.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>


@interface TrustedApplication : NSCachedObject {
    SecTrustedApplicationRef trustedApplication;
    int error;
}

+ (TrustedApplication*)trustedApplicationWithPath:(NSString*)path;
+ (TrustedApplication*)trustedApplicationWithTrustedApplicationRef:(SecTrustedApplicationRef)trustedApp;

- (TrustedApplication*)initWithPath:(NSString*)path;
- (TrustedApplication*)initWithTrustedApplicationRef:(SecTrustedApplicationRef)trustedApp;

- (void)setData:(NSData*)data;
- (NSData*)data;

- (int)lastError;
- (SecTrustedApplicationRef)trustedApplicationRef;

@end
